<?php
// en composer.json mantienes la lista de lo que quieres se descargue instale..

// Directorio actual
$dir = __DIR__;

// Especificar la ruta completa a PHP
$phpPath = '/opt/plesk/php/8.0/bin/php'; // Reemplaza esto con la ruta correcta a PHP en tu servidor

// Verificar que el archivo composer existe y tiene permisos de ejecución
$composerPath = $dir . '/composer';
if (!file_exists($composerPath)) {
    die("El archivo 'composer' no existe en el directorio '$dir'.");
}
if (!is_executable($composerPath)) {
    die("El archivo 'composer' no tiene permisos de ejecución.");
}

// Eliminar composer.lock si existe
$lockFilePath = $dir . '/composer.lock';
if (file_exists($lockFilePath)) {
    unlink($lockFilePath);
    echo "Archivo 'composer.lock' eliminado.<br>";
}

// Ejecutar Composer usando la ruta completa a PHP y al archivo composer en el mismo directorio
// el update tambien hace que si borras archivos de composer.json se borren
$output = [];
exec($phpPath . ' ' . $composerPath . ' update 2>&1', $output, $returnVar);

// Mostrar la salida
if ($returnVar !== 0) {
    echo "Error al ejecutar Composer:<br>";
}
echo "<pre>" . implode("\n", $output) . "</pre>";
?>